(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     74459,       1592]
NotebookOptionsPosition[     70991,       1471]
NotebookOutlinePosition[     71598,       1493]
CellTagsIndexPosition[     71555,       1490]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "\n",
 StyleBox["Z pore, IPE, Bisquert",
  FontFamily->"Arial",
  FontSize->20]
}], "Title",
 CellChangeTimes->{
  3.475865912414785*^9, {3.475865943298551*^9, 3.475865955268236*^9}, {
   3.4758660429022484`*^9, 3.475866079428337*^9}, {3.475866316276884*^9, 
   3.4758663189490376`*^9}, {3.4899180970833187`*^9, 
   3.4899181046177497`*^9}, {3.521476712575059*^9, 3.5214767156602354`*^9}, {
   3.5214771897083497`*^9, 3.521477193004538*^9}, {3.5218873523293095`*^9, 
   3.5218873564375443`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Off", "[", 
    RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4899223475414314`*^9, 3.489922372043833*^9}, {
  3.489922422316708*^9, 3.4899225446377044`*^9}, {3.4899231471981688`*^9, 
  3.489923148842263*^9}, {3.5218889390790663`*^9, 3.521888942727275*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"lof\"\>", ",", "\<\"Z1\"\>", ",", "\<\"Z2\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.4899224480931826`*^9, 3.4899224680093217`*^9}, {
   3.4899225132789106`*^9, 3.489922572867319*^9}, 3.4899227588979597`*^9, 
   3.4899229525470357`*^9, {3.489923150031331*^9, 3.4899231591338515`*^9}, 
   3.4899232103387804`*^9, {3.4899232425756245`*^9, 3.489923428631266*^9}, 
   3.4899235748226275`*^9, 3.489924077427375*^9, 3.4899241356177034`*^9, 
   3.4899242249058104`*^9, {3.4899242571656556`*^9, 3.4899242784588737`*^9}, 
   3.489924406675207*^9, 3.489924454993971*^9, 3.489924529655241*^9, 
   3.4899245705055776`*^9, 3.489924620959463*^9, 3.5214767197844715`*^9, 
   3.521482241373288*^9, 3.5218881575273647`*^9, 3.5218884336581583`*^9, 
   3.521888592062218*^9, 3.521888625525132*^9, 3.5218889436613283`*^9, 
   3.521889196707802*^9, 3.521889326388219*^9, 3.5218896353968935`*^9, 
   3.5218899920282917`*^9, 3.5218901311722507`*^9, 3.52189052996806*^9, 
   3.5218906339220057`*^9, 3.5218909004972534`*^9, 3.5218923925335927`*^9, 
   3.5218924780914865`*^9, 3.52189263061121*^9, 3.521893227968377*^9, 
   3.521902173010004*^9, 3.521904360150101*^9, 3.521905128757063*^9, 
   3.52191141682472*^9, 3.5708806831439295`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Lambda]", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"z", "/", 
    RowBox[{"(", 
     RowBox[{"rs", "+", "re"}], ")"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4756024908337126`*^9, 3.4756025132197514`*^9}, 
   3.475602710568898*^9, 3.4756028164586835`*^9, {3.475604014994418*^9, 
   3.4756040188336377`*^9}, {3.4756041023064117`*^9, 3.475604103042454*^9}, 
   3.4756042857619047`*^9, {3.4758607424280787`*^9, 3.4758607461322904`*^9}, {
   3.4758653363428354`*^9, 3.4758654700724845`*^9}, {3.4758656911581297`*^9, 
   3.475865692438203*^9}, {3.4758657258471136`*^9, 3.475865727415203*^9}, {
   3.4758660945682034`*^9, 3.4758662093987713`*^9}, 3.4758662524252324`*^9, 
   3.4758663224082355`*^9, {3.4758664993513556`*^9, 3.475866500230406*^9}, {
   3.4758665335913143`*^9, 3.47586653421535*^9}, {3.4759198606664486`*^9, 
   3.4759198680258694`*^9}, {3.4899183954853864`*^9, 
   3.4899186045743456`*^9}, {3.4899186811347246`*^9, 3.4899186819507713`*^9}, 
   3.48991949963054*^9, 3.489920529485444*^9, 3.4899208179169416`*^9, 
   3.4899211413724422`*^9, {3.4899227490373955`*^9, 3.4899227507164917`*^9}, {
   3.4899234830853806`*^9, 3.4899234915648656`*^9}, {3.5214767369024506`*^9, 
   3.5214767910695486`*^9}, {3.5218874144458623`*^9, 3.521887421799283*^9}, {
   3.521888146758748*^9, 3.5218881523740697`*^9}}],

Cell[BoxData[
 SqrtBox[
  FractionBox["z", 
   RowBox[{"re", "+", "rs"}]]]], "Output",
 CellChangeTimes->{
  3.4758662534972935`*^9, 3.475866335047958*^9, {3.475866502328526*^9, 
   3.4758665393516436`*^9}, 3.4759203266401005`*^9, 3.475925312701287*^9, 
   3.4759254050455685`*^9, 3.4759257188065147`*^9, {3.489918448983446*^9, 
   3.489918465956417*^9}, 3.489918513668146*^9, {3.489918683930885*^9, 
   3.4899186910602922`*^9}, 3.4899195218568115`*^9, {3.489920594466161*^9, 
   3.4899206118071527`*^9}, 3.4899206433429565`*^9, 3.4899206793910184`*^9, 
   3.4899208222991924`*^9, {3.4899208691178703`*^9, 3.489920894582327*^9}, 
   3.489921146848756*^9, 3.4899211805856853`*^9, 3.4899224035076323`*^9, 
   3.4899226322277145`*^9, 3.4899227628171835`*^9, 3.489922955856225*^9, 
   3.489923159211856*^9, 3.4899232103917837`*^9, {3.4899232426286273`*^9, 
   3.489923428688269*^9}, 3.4899235748896313`*^9, 3.4899240812145915`*^9, 
   3.489924135662706*^9, 3.489924224959813*^9, {3.4899242572166586`*^9, 
   3.4899242785008755`*^9}, 3.4899244067312098`*^9, 3.489924455040973*^9, 
   3.4899245297132444`*^9, 3.48992457054958*^9, 3.4899246210314674`*^9, 
   3.5214767923226204`*^9, 3.5214822414692936`*^9, 3.5218874249584637`*^9, 
   3.521888162891671*^9, 3.5218884337381625`*^9, 3.5218885921362224`*^9, 
   3.521888625603137*^9, 3.52188894980468*^9, 3.521889196776806*^9, 
   3.521889326452223*^9, 3.5218896354658976`*^9, 3.521889992102296*^9, 
   3.5218901312592554`*^9, 3.521890530038064*^9, 3.5218906339960103`*^9, 
   3.521890900582258*^9, 3.521892392620598*^9, 3.5218924781654906`*^9, 
   3.521892630713216*^9, 3.521893228041381*^9, 3.521902173234017*^9, 
   3.5219043602741084`*^9, 3.521905128830067*^9, 3.5219114170227313`*^9, 
   3.5708806832749367`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", "=", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{"\[ImaginaryI]", "*", "\[Omega]", "*", "cdl"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5218874289926944`*^9, 3.521887476006384*^9}, {
  3.5218880815430183`*^9, 3.5218880856382523`*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["\[ImaginaryI]", 
   RowBox[{"cdl", " ", "\[Omega]"}]]}]], "Output",
 CellChangeTimes->{3.5218874777724843`*^9, 3.5218881664108725`*^9, 
  3.5218884337651644`*^9, 3.5218885921592236`*^9, 3.5218886256331387`*^9, 
  3.5218889574351163`*^9, 3.521889196798807*^9, 3.5218893264732237`*^9, 
  3.5218896354938993`*^9, 3.5218899921302977`*^9, 3.521890131284257*^9, 
  3.5218905300670657`*^9, 3.5218906340210114`*^9, 3.52189090061626*^9, 
  3.5218923926505995`*^9, 3.521892478196492*^9, 3.5218926307522182`*^9, 
  3.521893228074383*^9, 3.5219021732630186`*^9, 3.5219043602991095`*^9, 
  3.5219051288540688`*^9, 3.5219114170507326`*^9, 3.5708806833039384`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rop", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"re", "^", "2"}], "+", 
      RowBox[{"rs", "^", "2"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"re", "+", "rs"}], ")"}]}], "*", "l"}]}]], "Input",
 CellChangeTimes->{{3.489919493284177*^9, 3.489919514409385*^9}, {
  3.489919545036137*^9, 3.4899195457091756`*^9}, {3.4899205360618205`*^9, 
  3.4899205457093725`*^9}, {3.489920600029479*^9, 3.489920601662573*^9}, {
  3.4899206933568172`*^9, 3.4899207059655385`*^9}, {3.489922938429228*^9, 
  3.489922940494346*^9}, {3.4899234965901527`*^9, 3.4899234985572653`*^9}, {
  3.489924026686473*^9, 3.4899240707649937`*^9}, {3.521476802942228*^9, 
  3.5214768260145473`*^9}, {3.5218875214459825`*^9, 3.521887541750144*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"l", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["re", "2"], "+", 
     SuperscriptBox["rs", "2"]}], ")"}]}], 
  RowBox[{"re", "+", "rs"}]]], "Output",
 CellChangeTimes->{{3.4899240733261404`*^9, 3.489924095086385*^9}, 
   3.4899241356907077`*^9, 3.4899242249958153`*^9, {3.48992425724566*^9, 
   3.4899242785248775`*^9}, 3.489924406761212*^9, 3.4899244550659747`*^9, 
   3.4899245297352457`*^9, 3.489924570574581*^9, 3.48992462107047*^9, 
   3.521476830184786*^9, 3.5214822414992957`*^9, 3.521887544764316*^9, 
   3.521888169612056*^9, 3.5218884337941656`*^9, 3.521888592186225*^9, 
   3.52188862566414*^9, 3.5218889628424253`*^9, 3.5218891968228083`*^9, 
   3.5218893264992256`*^9, 3.5218896355229006`*^9, 3.521889992157299*^9, 
   3.521890131309258*^9, 3.5218905300950675`*^9, 3.521890634048013*^9, 
   3.5218909006512623`*^9, 3.5218923926816015`*^9, 3.521892478228494*^9, 
   3.5218926307912207`*^9, 3.521893228108385*^9, 3.52190217329202*^9, 
   3.5219043603261113`*^9, 3.5219051288790703`*^9, 3.5219114170777345`*^9, 
   3.5708806833319397`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rop1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"re", "*", "rs"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"re", "+", "rs"}], ")"}]}], "*", "l"}]}]], "Input",
 CellChangeTimes->{{3.5218875514256973`*^9, 3.5218875836395397`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"l", " ", "re", " ", "rs"}], 
  RowBox[{"re", "+", "rs"}]]], "Output",
 CellChangeTimes->{3.5218875841585693`*^9, 3.521888171978191*^9, 
  3.521888433818167*^9, 3.5218885922192273`*^9, 3.5218886256921415`*^9, 
  3.521888976312196*^9, 3.52188919684581*^9, 3.5218893265232267`*^9, 
  3.5218896355539026`*^9, 3.5218899921843004`*^9, 3.5218901313352594`*^9, 
  3.5218905301200686`*^9, 3.521890634075015*^9, 3.521890900683264*^9, 
  3.5218923927116027`*^9, 3.521892478267496*^9, 3.521892630833223*^9, 
  3.521893228141387*^9, 3.521902173323022*^9, 3.521904360351113*^9, 
  3.5219051289010715`*^9, 3.521911417106736*^9, 3.570880683360942*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CapitalLambda]1", "=", 
  RowBox[{"l", "/", "\[Lambda]"}]}]], "Input",
 CellChangeTimes->{{3.5218876162424045`*^9, 3.5218876638301263`*^9}}],

Cell[BoxData[
 FractionBox["l", 
  SqrtBox[
   RowBox[{"-", 
    FractionBox["\[ImaginaryI]", 
     RowBox[{"cdl", " ", 
      RowBox[{"(", 
       RowBox[{"re", "+", "rs"}], ")"}], " ", "\[Omega]"}]]}]]]], "Output",
 CellChangeTimes->{{3.521887636233548*^9, 3.521887665390216*^9}, 
   3.5218881739133015`*^9, 3.5218884338441687`*^9, 3.5218885922472286`*^9, 
   3.521888625719143*^9, 3.521888981637501*^9, 3.521889196867811*^9, 
   3.521889326557229*^9, 3.521889635581904*^9, 3.5218899922103024`*^9, 
   3.521890131360261*^9, 3.5218905301470704`*^9, 3.521890634101016*^9, 
   3.5218909007182655`*^9, 3.5218923927386045`*^9, 3.5218924782964983`*^9, 
   3.521892630871225*^9, 3.521893228174389*^9, 3.5219021733530235`*^9, 
   3.521904360375114*^9, 3.521905128923073*^9, 3.521911417136738*^9, 
   3.570880683391943*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A1", "=", 
  RowBox[{"Rop1", "*", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", "/", 
      RowBox[{"(", 
       RowBox[{"\[CapitalLambda]1", "*", 
        RowBox[{"Sinh", "[", "\[CapitalLambda]1", "]"}]}], ")"}]}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5218877942095833`*^9, 3.5218878611264114`*^9}, {
   3.521889067399406*^9, 3.521889067766427*^9}, 3.5218923741515417`*^9, 
   3.521892463383645*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"l", " ", "re", " ", "rs", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"-", 
         FractionBox["\[ImaginaryI]", 
          RowBox[{"cdl", " ", 
           RowBox[{"(", 
            RowBox[{"re", "+", "rs"}], ")"}], " ", "\[Omega]"}]]}]], " ", 
       RowBox[{"Csch", "[", 
        FractionBox["l", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox["\[ImaginaryI]", 
            RowBox[{"cdl", " ", 
             RowBox[{"(", 
              RowBox[{"re", "+", "rs"}], ")"}], " ", "\[Omega]"}]]}]]], 
        "]"}]}], "l"]}], ")"}]}], 
  RowBox[{"re", "+", "rs"}]]], "Output",
 CellChangeTimes->{
  3.521887866198701*^9, 3.521888183418845*^9, 3.52188843387117*^9, 
   3.52188859227223*^9, 3.5218886257471447`*^9, {3.52188904316702*^9, 
   3.5218890694795246`*^9}, 3.5218891968918123`*^9, 3.5218893265822306`*^9, 
   3.521889635612906*^9, 3.5218899922373037`*^9, 3.521890131389263*^9, 
   3.521890530177072*^9, 3.5218906341260176`*^9, 3.5218909007512674`*^9, 
   3.5218923927756066`*^9, 3.5218924783335*^9, 3.5218926309102273`*^9, 
   3.5218932282213917`*^9, 3.521902173383025*^9, 3.5219043604031153`*^9, 
   3.521905128949074*^9, 3.52191141717374*^9, 3.570880683434946*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A2", "=", 
  RowBox[{
   RowBox[{"Rop", "/", "\[CapitalLambda]1"}], "*", 
   RowBox[{"Coth", "[", "\[CapitalLambda]1", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.521887890915115*^9, 3.521887929190304*^9}, 
   3.5218923814469585`*^9, 3.5218924691589756`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["re", "2"], "+", 
     SuperscriptBox["rs", "2"]}], ")"}], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox["\[ImaginaryI]", 
      RowBox[{"cdl", " ", 
       RowBox[{"(", 
        RowBox[{"re", "+", "rs"}], ")"}], " ", "\[Omega]"}]]}]], " ", 
   RowBox[{"Coth", "[", 
    FractionBox["l", 
     SqrtBox[
      RowBox[{"-", 
       FractionBox["\[ImaginaryI]", 
        RowBox[{"cdl", " ", 
         RowBox[{"(", 
          RowBox[{"re", "+", "rs"}], ")"}], " ", "\[Omega]"}]]}]]], "]"}]}], 
  RowBox[{"re", "+", "rs"}]]], "Output",
 CellChangeTimes->{3.5218879306973906`*^9, 3.521888187048053*^9, 
  3.521888433903172*^9, 3.5218885922992315`*^9, 3.5218886257781467`*^9, 
  3.5218890772979717`*^9, 3.521889196916814*^9, 3.521889326604232*^9, 
  3.5218896356429076`*^9, 3.5218899922683053`*^9, 3.5218901314182644`*^9, 
  3.5218905302070737`*^9, 3.521890634149019*^9, 3.52189090078327*^9, 
  3.521892392806608*^9, 3.521892478362502*^9, 3.5218926309522295`*^9, 
  3.5218932282583933`*^9, 3.521902173415027*^9, 3.521904360433118*^9, 
  3.5219051289750757`*^9, 3.521911417212742*^9, 3.5708806834669476`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z", "=", 
  RowBox[{"A1", "+", "A2"}]}]], "Input",
 CellChangeTimes->{{3.4899196353693037`*^9, 3.489919635410306*^9}, {
  3.489919769963002*^9, 3.489919835945776*^9}, {3.489920571068823*^9, 
  3.4899205713238373`*^9}, {3.5214769099183464`*^9, 3.521476931950607*^9}, {
  3.5218882012538652`*^9, 3.5218882038460135`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["re", "2"], "+", 
      SuperscriptBox["rs", "2"]}], ")"}], " ", 
    SqrtBox[
     RowBox[{"-", 
      FractionBox["\[ImaginaryI]", 
       RowBox[{"cdl", " ", 
        RowBox[{"(", 
         RowBox[{"re", "+", "rs"}], ")"}], " ", "\[Omega]"}]]}]], " ", 
    RowBox[{"Coth", "[", 
     FractionBox["l", 
      SqrtBox[
       RowBox[{"-", 
        FractionBox["\[ImaginaryI]", 
         RowBox[{"cdl", " ", 
          RowBox[{"(", 
           RowBox[{"re", "+", "rs"}], ")"}], " ", "\[Omega]"}]]}]]], "]"}]}], 
   RowBox[{"re", "+", "rs"}]], "+", 
  FractionBox[
   RowBox[{"l", " ", "re", " ", "rs", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"-", 
          FractionBox["\[ImaginaryI]", 
           RowBox[{"cdl", " ", 
            RowBox[{"(", 
             RowBox[{"re", "+", "rs"}], ")"}], " ", "\[Omega]"}]]}]], " ", 
        RowBox[{"Csch", "[", 
         FractionBox["l", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox["\[ImaginaryI]", 
             RowBox[{"cdl", " ", 
              RowBox[{"(", 
               RowBox[{"re", "+", "rs"}], ")"}], " ", "\[Omega]"}]]}]]], 
         "]"}]}], "l"]}], ")"}]}], 
   RowBox[{"re", "+", "rs"}]]}]], "Output",
 CellChangeTimes->{{3.489919810926345*^9, 3.4899198370458393`*^9}, 
   3.4899206119381604`*^9, 3.4899207942575884`*^9, 3.489920917215621*^9, 
   3.489921188294126*^9, 3.4899226455154743`*^9, 3.4899227708636436`*^9, 
   3.489922976008377*^9, 3.489923159312862*^9, 3.4899232104867887`*^9, {
   3.489923242732633*^9, 3.4899234287852745`*^9}, 3.4899235749976377`*^9, {
   3.489924109752224*^9, 3.489924135753711*^9}, 3.4899242250468187`*^9, {
   3.4899242573066635`*^9, 3.4899242785798807`*^9}, 3.489924406821215*^9, 
   3.489924455129978*^9, 3.4899245297882485`*^9, 3.489924570624584*^9, 
   3.4899246211514745`*^9, 3.521476933353687*^9, 3.5214822415522985`*^9, 
   3.5218882089873075`*^9, 3.521888433933174*^9, 3.521888592323233*^9, 
   3.5218886258101482`*^9, 3.5218890819342375`*^9, 3.5218891969428153`*^9, 
   3.521889326631233*^9, 3.5218896356749096`*^9, 3.5218899922983074`*^9, 
   3.521890131450266*^9, 3.521890530242076*^9, 3.52189063417702*^9, 
   3.5218909008162713`*^9, 3.5218923928376102`*^9, 3.5218924783935037`*^9, 
   3.521892630995232*^9, 3.5218932282923956`*^9, 3.521902173447029*^9, 
   3.5219043604651194`*^9, 3.521905128998077*^9, 3.5219114172507443`*^9, 
   3.57088068350095*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"re", "=", "200"}], "\[IndentingNewLine]", 
   RowBox[{"rs", "=", "50"}], "\[IndentingNewLine]", 
   RowBox[{"l", "=", "0.05"}], "\[IndentingNewLine]", 
   RowBox[{"cdl", "=", "0.001"}]}]}]], "Input",
 CellChangeTimes->{{3.5214769560369844`*^9, 3.52147701278323*^9}, {
   3.521888232566656*^9, 3.5218882696857796`*^9}, {3.5218896221991386`*^9, 
   3.521889622998184*^9}, {3.521890121446694*^9, 3.521890122053729*^9}, 
   3.521890523238675*^9, {3.521890625622531*^9, 3.521890626389575*^9}, {
   3.521890896263011*^9, 3.5218908968050423`*^9}, 3.521892611239102*^9, {
   3.5218932213189964`*^9, 3.5218932221010413`*^9}}],

Cell[BoxData["200"], "Output",
 CellChangeTimes->{
  3.521477020436668*^9, 3.5214822415943007`*^9, 3.521888273615004*^9, 
   3.521888433971176*^9, 3.5218885923492346`*^9, 3.5218886258461504`*^9, 
   3.5218890865395007`*^9, 3.5218891969658165`*^9, 3.5218893266562347`*^9, 
   3.5218896357099113`*^9, 3.5218899923293085`*^9, 3.521890131485268*^9, 
   3.521890530278078*^9, {3.521890630918834*^9, 3.5218906342060223`*^9}, 
   3.5218909008552732`*^9, 3.521892392872612*^9, 3.5218924784445066`*^9, 
   3.5218926310382347`*^9, 3.521893228336398*^9, 3.521902173482031*^9, 
   3.5219043605011215`*^9, 3.5219051290230784`*^9, 3.5219114173097477`*^9, 
   3.570880683529951*^9}],

Cell[BoxData["50"], "Output",
 CellChangeTimes->{
  3.521477020436668*^9, 3.5214822415943007`*^9, 3.521888273615004*^9, 
   3.521888433971176*^9, 3.5218885923492346`*^9, 3.5218886258461504`*^9, 
   3.5218890865395007`*^9, 3.5218891969658165`*^9, 3.5218893266562347`*^9, 
   3.5218896357099113`*^9, 3.5218899923293085`*^9, 3.521890131485268*^9, 
   3.521890530278078*^9, {3.521890630918834*^9, 3.5218906342060223`*^9}, 
   3.5218909008552732`*^9, 3.521892392872612*^9, 3.5218924784445066`*^9, 
   3.5218926310382347`*^9, 3.521893228336398*^9, 3.521902173482031*^9, 
   3.5219043605011215`*^9, 3.5219051290230784`*^9, 3.5219114173097477`*^9, 
   3.5708806835339513`*^9}],

Cell[BoxData["0.05`"], "Output",
 CellChangeTimes->{
  3.521477020436668*^9, 3.5214822415943007`*^9, 3.521888273615004*^9, 
   3.521888433971176*^9, 3.5218885923492346`*^9, 3.5218886258461504`*^9, 
   3.5218890865395007`*^9, 3.5218891969658165`*^9, 3.5218893266562347`*^9, 
   3.5218896357099113`*^9, 3.5218899923293085`*^9, 3.521890131485268*^9, 
   3.521890530278078*^9, {3.521890630918834*^9, 3.5218906342060223`*^9}, 
   3.5218909008552732`*^9, 3.521892392872612*^9, 3.5218924784445066`*^9, 
   3.5218926310382347`*^9, 3.521893228336398*^9, 3.521902173482031*^9, 
   3.5219043605011215`*^9, 3.5219051290230784`*^9, 3.5219114173097477`*^9, 
   3.5708806835379515`*^9}],

Cell[BoxData["0.001`"], "Output",
 CellChangeTimes->{
  3.521477020436668*^9, 3.5214822415943007`*^9, 3.521888273615004*^9, 
   3.521888433971176*^9, 3.5218885923492346`*^9, 3.5218886258461504`*^9, 
   3.5218890865395007`*^9, 3.5218891969658165`*^9, 3.5218893266562347`*^9, 
   3.5218896357099113`*^9, 3.5218899923293085`*^9, 3.521890131485268*^9, 
   3.521890530278078*^9, {3.521890630918834*^9, 3.5218906342060223`*^9}, 
   3.5218909008552732`*^9, 3.521892392872612*^9, 3.5218924784445066`*^9, 
   3.5218926310382347`*^9, 3.521893228336398*^9, 3.521902173482031*^9, 
   3.5219043605011215`*^9, 3.5219051290230784`*^9, 3.5219114173097477`*^9, 
   3.5708806835549526`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{"Rop", "\[IndentingNewLine]", "Rop1"}], "Input",
 CellChangeTimes->{{3.5218889099984035`*^9, 3.521888920069979*^9}}],

Cell[BoxData["8.5`"], "Output",
 CellChangeTimes->{3.521888921846081*^9, 3.5218890893846636`*^9, 
  3.5218891969938183`*^9, 3.5218893266862364`*^9, 3.521889635751914*^9, 
  3.5218899923693113`*^9, 3.5218901315272703`*^9, 3.5218905303190804`*^9, 
  3.521890634240024*^9, 3.5218909008982763`*^9, 3.5218923929156146`*^9, 
  3.5218924784825087`*^9, 3.521892631077237*^9, 3.5218932283764*^9, 
  3.5219021735210333`*^9, 3.521904360540124*^9, 3.5219051290610805`*^9, 
  3.5219114173607507`*^9, 3.5708806835969553`*^9}],

Cell[BoxData["2.`"], "Output",
 CellChangeTimes->{3.521888921846081*^9, 3.5218890893846636`*^9, 
  3.5218891969938183`*^9, 3.5218893266862364`*^9, 3.521889635751914*^9, 
  3.5218899923693113`*^9, 3.5218901315272703`*^9, 3.5218905303190804`*^9, 
  3.521890634240024*^9, 3.5218909008982763`*^9, 3.5218923929156146`*^9, 
  3.5218924784825087`*^9, 3.521892631077237*^9, 3.5218932283764*^9, 
  3.5219021735210333`*^9, 3.521904360540124*^9, 3.5219051290610805`*^9, 
  3.5219114173607507`*^9, 3.570880683600955*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z1", "=", 
  RowBox[{"Re", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.4756027762914133`*^9, 3.4756028011266575`*^9}, {
  3.4756040395058203`*^9, 3.475604052081539*^9}, {3.4756041113939314`*^9, 
  3.4756041300820007`*^9}}],

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{
   RowBox[{"170", " ", 
    SqrtBox[
     RowBox[{"-", 
      FractionBox[
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]], " ", 
    RowBox[{"Coth", "[", 
     FractionBox["0.05`", 
      SqrtBox[
       RowBox[{"-", 
        FractionBox[
         RowBox[{"0.`", "\[VeryThinSpace]", "+", 
          RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]]], "]"}]}], 
   "+", 
   RowBox[{"2.`", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"40.`", " ", 
       SqrtBox[
        RowBox[{"-", 
         FractionBox[
          RowBox[{"0.`", "\[VeryThinSpace]", "+", 
           RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]], " ", 
       RowBox[{"Csch", "[", 
        FractionBox["0.05`", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            RowBox[{"0.`", "\[VeryThinSpace]", "+", 
             RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]]], 
        "]"}]}]}], ")"}]}]}], "]"}]], "Output",
 CellChangeTimes->{
  3.4756041304820232`*^9, 3.475604299998719*^9, 3.4756046260313673`*^9, 
   3.475605069487732*^9, 3.475605307968372*^9, 3.4756055565595903`*^9, 
   3.475605587584365*^9, 3.4756064833746014`*^9, 3.4756067559661922`*^9, 
   3.475834091328723*^9, 3.4758607565378857`*^9, 3.475860836289447*^9, 
   3.4758608818960557`*^9, 3.47586145159564*^9, 3.4758621827884626`*^9, 
   3.4758636999372387`*^9, 3.475863857160231*^9, 3.4758644852861576`*^9, 
   3.475865509093716*^9, 3.4758657382608237`*^9, 3.475865783813429*^9, 
   3.475866365413695*^9, 3.4758665502132645`*^9, 3.47592033380051*^9, 
   3.475925332233404*^9, 3.475925412666004*^9, 3.475925724442837*^9, 
   3.4899206122051754`*^9, {3.4899208080803795`*^9, 3.4899208368180227`*^9}, 
   3.489920925986123*^9, 3.4899211934174194`*^9, 3.4899226559930735`*^9, 
   3.489922773804812*^9, 3.489922979213561*^9, 3.489923159539875*^9, 
   3.4899232107058015`*^9, {3.489923242954646*^9, 3.4899234290102873`*^9}, 
   3.489923575062641*^9, 3.489924135787713*^9, 3.4899242250688195`*^9, {
   3.489924257340666*^9, 3.489924278606882*^9}, 3.4899244068542175`*^9, 
   3.48992445516198*^9, 3.4899245298112497`*^9, 3.4899245706485853`*^9, 
   3.489924621187476*^9, 3.521477028854149*^9, 3.521482241633303*^9, 
   3.5218882799183645`*^9, 3.5218884340211787`*^9, 3.521888592376236*^9, 
   3.521888625890153*^9, 3.5218890919008074`*^9, 3.5218891970198197`*^9, 
   3.521889326713238*^9, 3.5218896357789154`*^9, 3.521889992395313*^9, 
   3.5218901315542717`*^9, 3.521890530349082*^9, 3.521890634269026*^9, 
   3.521890900921277*^9, 3.5218923929406157`*^9, 3.5218924785095105`*^9, 
   3.5218926311042385`*^9, 3.5218932284014015`*^9, 3.5219021735520353`*^9, 
   3.5219043605711255`*^9, 3.521905129100083*^9, 3.5219114173947525`*^9, 
   3.570880683636957*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Z2", "=", 
   RowBox[{"Im", "[", "Z", "]"}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.475603397013071*^9, 3.475603412257943*^9}, {
   3.475603661106177*^9, 3.475603666913509*^9}, {3.4756040676824317`*^9, 
   3.4756040802901525`*^9}, {3.4756041338742175`*^9, 3.4756041435377703`*^9}, 
   3.475604562034707*^9, {3.4758656219591713`*^9, 3.475865624116295*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"170", " ", 
   RowBox[{"Im", "[", 
    RowBox[{
     SqrtBox[
      RowBox[{"-", 
       FractionBox[
        RowBox[{"0.`", "\[VeryThinSpace]", "+", 
         RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]], " ", 
     RowBox[{"Coth", "[", 
      FractionBox["0.05`", 
       SqrtBox[
        RowBox[{"-", 
         FractionBox[
          RowBox[{"0.`", "\[VeryThinSpace]", "+", 
           RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]]], "]"}]}], 
    "]"}]}], "+", 
  RowBox[{"80.`", " ", 
   RowBox[{"Im", "[", 
    RowBox[{
     SqrtBox[
      RowBox[{"-", 
       FractionBox[
        RowBox[{"0.`", "\[VeryThinSpace]", "+", 
         RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]], " ", 
     RowBox[{"Csch", "[", 
      FractionBox["0.05`", 
       SqrtBox[
        RowBox[{"-", 
         FractionBox[
          RowBox[{"0.`", "\[VeryThinSpace]", "+", 
           RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]]], "]"}]}], 
    "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.475604565742919*^9, {3.4756046024010153`*^9, 3.4756046273434424`*^9}, 
   3.4756050707028008`*^9, 3.4756053092004423`*^9, 3.475605594479759*^9, 
   3.47560648475068*^9, 3.475606757023253*^9, 3.4758340921947727`*^9, 
   3.475860756573888*^9, 3.4758608363174486`*^9, 3.475860882808108*^9, 
   3.4758614516256423`*^9, 3.4758621878467517`*^9, 3.475863701205311*^9, 
   3.475863857799268*^9, 3.4758644868702483`*^9, 3.4758655122128944`*^9, 
   3.475865625669384*^9, 3.4758657392538805`*^9, 3.475865786836602*^9, 
   3.4758663688998947`*^9, 3.475866552470394*^9, 3.4759203347165623`*^9, 
   3.47592533636064*^9, 3.475925413753067*^9, 3.475925726105932*^9, 
   3.4899206122361774`*^9, 3.489920930045355*^9, 3.4899211964425917`*^9, 
   3.4899226592942624`*^9, 3.489922774940877*^9, 3.4899229808136525`*^9, 
   3.489923159572877*^9, 3.489923210735803*^9, {3.4899232429846478`*^9, 
   3.489923429038289*^9}, 3.4899235750996437`*^9, 3.489924135822715*^9, 
   3.489924225093821*^9, {3.4899242573756676`*^9, 3.489924278632883*^9}, 
   3.4899244068942194`*^9, 3.4899244551989822`*^9, 3.4899245298372517`*^9, 
   3.489924570676587*^9, 3.4899246212264786`*^9, 3.5214770317973175`*^9, 
   3.521482241671305*^9, 3.5218882834865685`*^9, 3.521888434054181*^9, 
   3.5218885923992376`*^9, 3.521888625921155*^9, 3.521889094099933*^9, 
   3.521889197045821*^9, 3.5218893267362394`*^9, 3.521889635806917*^9, 
   3.5218899924253144`*^9, 3.521890131583274*^9, 3.5218905303800836`*^9, 
   3.521890634300028*^9, 3.521890900950279*^9, 3.5218923929716177`*^9, 
   3.521892478538512*^9, 3.5218926311272397`*^9, 3.521893228428403*^9, 
   3.5219021735800366`*^9, 3.521904360597127*^9, 3.521905129138085*^9, 
   3.5219114174227543`*^9, 3.5708806836709595`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZA11", "=", 
  RowBox[{"Re", "[", "A1", "]"}]}]], "Input",
 CellChangeTimes->{{3.521888301550602*^9, 3.5218883284371395`*^9}}],

Cell[BoxData[
 RowBox[{"2.`", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"40.`", " ", 
     RowBox[{"Re", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{"-", 
         FractionBox[
          RowBox[{"0.`", "\[VeryThinSpace]", "+", 
           RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]], " ", 
       RowBox[{"Csch", "[", 
        FractionBox["0.05`", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            RowBox[{"0.`", "\[VeryThinSpace]", "+", 
             RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]]], 
        "]"}]}], "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.5218883302802453`*^9, 3.5218884340861826`*^9, 
  3.5218885924242387`*^9, 3.521888625954157*^9, 3.5218890954360094`*^9, 
  3.521889197068823*^9, 3.5218893267642407`*^9, 3.5218896358379188`*^9, 
  3.521889992455316*^9, 3.521890131614276*^9, 3.521890530411085*^9, 
  3.5218906343320293`*^9, 3.5218909009792805`*^9, 3.5218923930026197`*^9, 
  3.521892478573514*^9, 3.5218926311522408`*^9, 3.521893228457405*^9, 
  3.5219021736120386`*^9, 3.5219043606291285`*^9, 3.521905129179087*^9, 
  3.521911417452756*^9, 3.570880683705961*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZA12", "=", 
  RowBox[{"Im", "[", "A1", "]"}]}]], "Input",
 CellChangeTimes->{{3.521888333545432*^9, 3.521888352710528*^9}, {
  3.521889101094333*^9, 3.52188910261442*^9}}],

Cell[BoxData[
 RowBox[{"80.`", " ", 
  RowBox[{"Im", "[", 
   RowBox[{
    SqrtBox[
     RowBox[{"-", 
      FractionBox[
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]], " ", 
    RowBox[{"Csch", "[", 
     FractionBox["0.05`", 
      SqrtBox[
       RowBox[{"-", 
        FractionBox[
         RowBox[{"0.`", "\[VeryThinSpace]", "+", 
          RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]]], "]"}]}], 
   "]"}]}]], "Output",
 CellChangeTimes->{{3.5218883479622564`*^9, 3.5218883554486847`*^9}, 
   3.521888434118184*^9, 3.5218885924482403`*^9, 3.521888625990159*^9, {
   3.5218890976751375`*^9, 3.521889104084504*^9}, 3.521889197090824*^9, 
   3.5218893267882423`*^9, 3.521889635870921*^9, 3.521889992489318*^9, 
   3.5218901316482773`*^9, 3.521890530442087*^9, 3.5218906343650312`*^9, 
   3.521890901013283*^9, 3.5218923930356216`*^9, 3.521892478609516*^9, 
   3.521892631179242*^9, 3.521893228490407*^9, 3.5219021736450405`*^9, 
   3.5219043606601305`*^9, 3.52190512922009*^9, 3.5219114174867578`*^9, 
   3.570880683757964*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZA21", "=", 
  RowBox[{"Re", "[", "A2", "]"}]}]], "Input",
 CellChangeTimes->{{3.521888358393853*^9, 3.521888373701729*^9}}],

Cell[BoxData[
 RowBox[{"170", " ", 
  RowBox[{"Re", "[", 
   RowBox[{
    SqrtBox[
     RowBox[{"-", 
      FractionBox[
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]], " ", 
    RowBox[{"Coth", "[", 
     FractionBox["0.05`", 
      SqrtBox[
       RowBox[{"-", 
        FractionBox[
         RowBox[{"0.`", "\[VeryThinSpace]", "+", 
          RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]]], "]"}]}], 
   "]"}]}]], "Output",
 CellChangeTimes->{3.5218883764548864`*^9, 3.521888434158187*^9, 
  3.5218885924702415`*^9, 3.521888626030161*^9, 3.5218891084087515`*^9, 
  3.521889197116825*^9, 3.5218893268122435`*^9, 3.5218896359099226`*^9, 
  3.52188999253032*^9, 3.5218901316862793`*^9, 3.521890530480089*^9, 
  3.521890634407034*^9, 3.5218909010532846`*^9, 3.5218923930776243`*^9, 
  3.5218924786505184`*^9, 3.521892631202244*^9, 3.5218932285314093`*^9, 
  3.5219021736810427`*^9, 3.5219043606971326`*^9, 3.5219051292560916`*^9, 
  3.5219114175247602`*^9, 3.5708806837939663`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZA22", "=", 
  RowBox[{"Im", "[", "A2", "]"}]}]], "Input",
 CellChangeTimes->{{3.521888380699129*^9, 3.5218883956699853`*^9}}],

Cell[BoxData[
 RowBox[{"170", " ", 
  RowBox[{"Im", "[", 
   RowBox[{
    SqrtBox[
     RowBox[{"-", 
      FractionBox[
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]], " ", 
    RowBox[{"Coth", "[", 
     FractionBox["0.05`", 
      SqrtBox[
       RowBox[{"-", 
        FractionBox[
         RowBox[{"0.`", "\[VeryThinSpace]", "+", 
          RowBox[{"4.`", " ", "\[ImaginaryI]"}]}], "\[Omega]"]}]]], "]"}]}], 
   "]"}]}]], "Output",
 CellChangeTimes->{3.5218883967120447`*^9, 3.5218884341951885`*^9, 
  3.5218885924932427`*^9, 3.5218886260741634`*^9, 3.521889125211713*^9, 
  3.521889197142827*^9, 3.521889326835245*^9, 3.521889635944925*^9, 
  3.5218899925683227`*^9, 3.521890131723282*^9, 3.5218905305150914`*^9, 
  3.521890634447036*^9, 3.5218909010962877`*^9, 3.521892393113626*^9, 
  3.5218924786875205`*^9, 3.5218926312282453`*^9, 3.521893228568411*^9, 
  3.5219021737140446`*^9, 3.521904360728134*^9, 3.521905129291094*^9, 
  3.521911417559762*^9, 3.570880683827968*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Omega]", "=", 
  RowBox[{
   RowBox[{"10", "^", "lof"}], "*", "2", "*", "Pi"}]}]], "Input",
 CellChangeTimes->{{3.475604406255797*^9, 3.4756044290911026`*^9}, 
   3.47560454915497*^9, 3.47560507854525*^9, {3.4756054024017735`*^9, 
   3.475605407505065*^9}, {3.4756054887057095`*^9, 3.475605491408864*^9}, {
   3.521911375551359*^9, 3.5219113823117456`*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{"1", "+", "lof"}]], " ", 
  SuperscriptBox["5", "lof"], " ", "\[Pi]"}]], "Output",
 CellChangeTimes->{
  3.4899229839778333`*^9, 3.4899231596498814`*^9, 3.4899232108068075`*^9, {
   3.4899232430546513`*^9, 3.4899234291122932`*^9}, 3.4899235751856484`*^9, 
   3.4899241359017196`*^9, 3.489924225143824*^9, {3.489924257452672*^9, 
   3.4899242786838865`*^9}, 3.489924406972224*^9, 3.489924455276987*^9, 
   3.4899245298892546`*^9, 3.4899245707255898`*^9, 3.489924621304483*^9, 
   3.521477038685712*^9, 3.5214822417433095`*^9, 3.5218884342271905`*^9, 
   3.5218885925172443`*^9, 3.5218886261051655`*^9, 3.5218891277958603`*^9, 
   3.5218891971648283`*^9, 3.5218893268602467`*^9, 3.521889635972926*^9, 
   3.5218899925983243`*^9, 3.521890131754284*^9, 3.521890530544093*^9, 
   3.521890634478038*^9, 3.521890901123289*^9, 3.5218923931436276`*^9, 
   3.521892478716522*^9, 3.521892631257247*^9, 3.5218932285964127`*^9, 
   3.5219021737450457`*^9, 3.5219043607571363`*^9, 3.5219051293270955`*^9, 
   3.5219114175897636`*^9, 3.57088068386197*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Z1", ",", "Z2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lof", ",", "2", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4756034305039873`*^9, 3.4756034317770596`*^9}, {
   3.4756034944846463`*^9, 3.475603513969761*^9}, {3.475603551473906*^9, 
   3.475603587393961*^9}, 3.4756036488824778`*^9, {3.4756036989943438`*^9, 
   3.4756037027855606`*^9}, {3.4756039087223396`*^9, 
   3.4756039240022135`*^9}, {3.475603989492959*^9, 3.475604001249632*^9}, {
   3.475604151650234*^9, 3.4756041615057983`*^9}, {3.475604357794025*^9, 
   3.47560439371408*^9}, {3.475605209794757*^9, 3.4756052162581263`*^9}, {
   3.4756054334265475`*^9, 3.475605473281827*^9}, {3.475605514436181*^9, 
   3.4756055396506233`*^9}, 3.475865811559016*^9, 3.4758664622142315`*^9, 
   3.4899210018204603`*^9, {3.489921220908992*^9, 3.48992123574084*^9}, {
   3.5214770962080016`*^9, 3.521477119023307*^9}, {3.521888419623355*^9, 
   3.5218884200383787`*^9}, {3.521889136119336*^9, 3.521889146198913*^9}, 
   3.521905292455426*^9, 3.521911388120078*^9, 3.570880672100298*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc4Vv3/APDb3vd93FZGZhnZOzI+RqiMPCES0RMhja+QpPEIZUVCEW4U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     "]]}},
  Axes->True,
  AxesOrigin->{2., 0},
  Method->{},
  PlotRange->{{2.030330109974597, 4.165159466702511}, {-11.351050661851335`, 
   0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5219021738590527`*^9, 3.5219043608151393`*^9, 3.521905129375098*^9, 
   3.521905294481542*^9, 3.5219114176727686`*^9, {3.570880676979576*^9, 
   3.570880683929974*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5219007065651283`*^9, 3.5219007065841293`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ZA11", ",", "ZA12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lof", ",", "2", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758610857867174`*^9, 3.4758610994945016`*^9}, {
   3.47586139511141*^9, 3.4758614066940727`*^9}, 3.475861522949722*^9, {
   3.475861586262343*^9, 3.475861623062448*^9}, 3.4758639548218164`*^9, {
   3.475864446741953*^9, 3.4758644503101573`*^9}, {3.4758646109663463`*^9, 
   3.4758646390459523`*^9}, {3.4758646771931343`*^9, 3.4758646914299483`*^9}, 
   3.4758665906145754`*^9, 3.4759254965058002`*^9, 3.4899212624123654`*^9, {
   3.4899227056129117`*^9, 3.4899227097861505`*^9}, 3.5214822947193394`*^9, {
   3.521888447014922*^9, 3.521888491815484*^9}, 3.521911393096363*^9, {
   3.5708806957146482`*^9, 3.570880708003351*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw923c8lt//OHAjKSR7ZCspZETScB0aSLbSJCuULUVWZqWQrayy1y2jgeI+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     "]]}},
  Axes->True,
  AxesOrigin->{1.4000000000000001`, 0},
  Method->{},
  PlotRange->{{1.334596013182031, 2.00770679993698}, {-2.9204734836572364`, 
   0.05643276553500363}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5219021739270563`*^9, 3.5219043608731422`*^9, 3.5219051294511027`*^9, 
   3.5219114177597733`*^9, {3.57088068403298*^9, 3.57088070973645*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.521900703764968*^9, 3.5219007037809687`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ZA21", ",", "ZA22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lof", ",", "2", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758647127111654`*^9, 3.475864726693966*^9}, {
   3.4758648002301717`*^9, 3.475864817174141*^9}, {3.521888509415491*^9, 
   3.5218885326958227`*^9}, 3.5219113972395997`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Xk4Ff3fwHHOOTP2sh5bsmWLpGyVMt+UyJYIUSRF1iiyy5It3XZJqKNE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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0., 2.8305634535204782`}, {-8.43060116424651, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5219021739650583`*^9, 3.521904360913145*^9, 
  3.5219051295031056`*^9, 3.5219114177997756`*^9, 3.5708806840919833`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$MaxExtraPrecision", "=", "50"}]], "Input",
 CellChangeTimes->{{3.5219006982126503`*^9, 3.5219006982316513`*^9}, {
  3.5219050890617924`*^9, 3.521905100470445*^9}}],

Cell[BoxData["50"], "Output",
 CellChangeTimes->{{3.5219051062477756`*^9, 3.5219051295181065`*^9}, 
   3.521911417815777*^9, 3.570880684122985*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"pore1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "lof", ",", "Z1", ",", "Z2", ",", "ZA11", ",", "ZA12", ",", "ZA21", ",",
        "ZA22"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"lof", ",", 
       RowBox[{"-", "2"}], ",", "7", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.48224695415106*^9, 3.4822470058780184`*^9}, 
   3.482247616006916*^9, 3.482249406678336*^9, {3.4899180741550074`*^9, 
   3.489918075995113*^9}, 3.4899212882048407`*^9, {3.4899214747325096`*^9, 
   3.4899214784287205`*^9}, {3.4899218207332993`*^9, 3.489921838733329*^9}, {
   3.4899218689890594`*^9, 3.4899218743173647`*^9}, {3.5214771395024776`*^9, 
   3.521477155727406*^9}, {3.5218885571592216`*^9, 3.5218885778004026`*^9}, {
   3.521888616026589*^9, 3.5218886178476934`*^9}, 3.52188931853577*^9, 
   3.521889982983774*^9, 3.5219051233047514`*^9, {3.5219114029689274`*^9, 
   3.521911407609193*^9}, 3.521911476249119*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<pore1.txt\>\"", ",", "pore1", ",", "\"\<Table\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.4822493502621098`*^9, 3.482249404502212*^9, {3.5214771654379616`*^9, 
   3.521477166414017*^9}, {3.5214772797595005`*^9, 3.521477280894565*^9}}],

Cell[BoxData["\<\"pore1.txt\"\>"], "Output",
 CellChangeTimes->{
  3.4822470588200464`*^9, 3.4822494180059843`*^9, 3.4899206141082845`*^9, 
   3.489921297854392*^9, 3.489921507021356*^9, 3.4899219563290553`*^9, 
   3.4899231604799285`*^9, 3.4899232116098533`*^9, {3.489923243844697*^9, 
   3.4899234299013386`*^9}, 3.489923576874745*^9, 3.489924137500811*^9, 
   3.4899242266079073`*^9, {3.489924259050763*^9, 3.4899242800389633`*^9}, 
   3.48992440848431*^9, 3.489924456798074*^9, 3.4899245311753283`*^9, 
   3.489924572106669*^9, 3.4899246228165693`*^9, 3.521477172796382*^9, 
   3.521477284913795*^9, 3.5214822422093363`*^9, 3.521888435924288*^9, {
   3.521888586032873*^9, 3.521888593822319*^9}, 3.5218886267072*^9, 
   3.5218891977378607`*^9, 3.5218893274762816`*^9, 3.521889636575961*^9, 
   3.521889993244361*^9, 3.52189013240032*^9, 3.52189053118713*^9, 
   3.521890635130075*^9, 3.521890901785327*^9, 3.521892393817666*^9, 
   3.5218924793715596`*^9, 3.521892631782277*^9, 3.5218932292434497`*^9, 
   3.521902174817107*^9, 3.521904361425174*^9, {3.521905116755377*^9, 
   3.521905129597111*^9}, 3.5219114182288003`*^9, 3.5708806849330316`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1902, 918},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{600, 780}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->2.000000238418579,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 512, 12, 233, "Title"],
Cell[CellGroupData[{
Cell[1104, 38, 589, 10, 213, "Input"],
Cell[1696, 50, 1265, 19, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2998, 74, 1337, 21, 60, "Input"],
Cell[4338, 97, 1757, 27, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6132, 129, 278, 7, 60, "Input"],
Cell[6413, 138, 693, 11, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7143, 154, 776, 16, 60, "Input"],
Cell[7922, 172, 1101, 20, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9060, 197, 275, 8, 60, "Input"],
Cell[9338, 207, 674, 11, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10049, 223, 166, 3, 60, "Input"],
Cell[10218, 228, 816, 16, 164, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11071, 249, 450, 12, 60, "Input"],
Cell[11524, 263, 1305, 31, 249, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12866, 299, 281, 6, 60, "Input"],
Cell[13150, 307, 1196, 29, 176, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14383, 341, 343, 6, 60, "Input"],
Cell[14729, 349, 2569, 61, 249, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17335, 415, 686, 12, 213, "Input"],
Cell[18024, 429, 667, 10, 85, "Output"],
Cell[18694, 441, 668, 10, 85, "Output"],
Cell[19365, 453, 671, 10, 85, "Output"],
Cell[20039, 465, 672, 10, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20748, 480, 130, 1, 99, "Input"],
Cell[20881, 483, 511, 7, 85, "Output"],
Cell[21395, 492, 508, 7, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21940, 504, 253, 5, 60, "Input"],
Cell[22196, 511, 2863, 59, 148, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25096, 575, 410, 7, 99, "Input"],
Cell[25509, 584, 2778, 58, 149, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28324, 647, 150, 3, 60, "Input"],
Cell[28477, 652, 1171, 27, 148, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29685, 684, 196, 4, 60, "Input"],
Cell[29884, 690, 1106, 25, 149, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31027, 720, 148, 3, 60, "Input"],
Cell[31178, 725, 1054, 24, 149, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32269, 754, 150, 3, 60, "Input"],
Cell[32422, 759, 1045, 24, 149, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33504, 788, 383, 7, 60, "Input"],
Cell[33890, 797, 1098, 18, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35025, 820, 1144, 19, 60, "Input"],
Cell[36172, 841, 6240, 110, 920, "Output"]
}, Open  ]],
Cell[42427, 954, 96, 1, 60, "Input"],
Cell[CellGroupData[{
Cell[42548, 959, 857, 15, 60, "Input"],
Cell[43408, 976, 18195, 305, 953, "Output"]
}, Open  ]],
Cell[61618, 1284, 94, 1, 60, "Input"],
Cell[CellGroupData[{
Cell[61737, 1289, 402, 9, 60, "Input"],
Cell[62142, 1300, 5943, 103, 920, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68122, 1408, 188, 3, 60, "Input"],
Cell[68313, 1413, 147, 2, 85, "Output"]
}, Open  ]],
Cell[68475, 1418, 1012, 21, 60, "Input"],
Cell[CellGroupData[{
Cell[69512, 1443, 296, 6, 60, "Input"],
Cell[69811, 1451, 1152, 16, 142, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
